Input.keyMapper = {
	8: 'backspace',
    9: 'tab',       // tab

    13: 'enter',
    16: 'shift',    // shift
    17: 'ctrl',     // control
    18: 'alt',
	19: 'pause',
    27: 'esc',
    32: 'space',
    33: 'pageup',   // pageup
    34: 'pagedown', // pagedown
	35: 'end',
	36: 'home',
    37: 'left',     // left arrow
    38: 'up',       // up arrow
    39: 'right',    // right arrow
    40: 'down',     // down arrow
    45: 'insert',
	46: 'delete',
	48: '0',
	49: '1',
	50: '2',
	51: '3',
	52: '4',
	53: '5',
	54: '6',
	55: '7',
	56: '8',
	57: '9',

/*
	58: 'period', //not correct?
	59: 'semicolon',
	60: 'backquote',
	61: 'equal',
	63: 'minus',
*/

	65: 'a',
	66: 'b',
	67: 'c',
	68: 'd',
	69: 'e',
	70: 'f',
	71: 'g',
	72: 'h',
	73: 'i',
	74: 'j',
	75: 'k',
	76: 'l',
	77: 'm',
	78: 'n',
	79: 'o',
	80: 'p',
	81: 'q',
	82: 'r',
	83: 's',
	84: 't',
	85: 'u',
	86: 'v',
	87: 'w',
	88: 'x',
	89: 'y',
	90: 'z',
	
    96: 'num0',
	97: 'num1',
    98: 'num2',
	99: 'num3',
    100: 'num4',
	101: 'num5',
    102: 'num6',
	103: 'num7',
    104: 'num8',
	105: 'num9',
	106: 'numstar',
	107: 'numplus',
	108: 'numdot', //also 110
	109: 'numminus',
	110: 'numdot',
	111: 'numslash',
	
	112: 'f1',
	113: 'f2',
	114: 'f3',
	115: 'f4',
	116: 'f5',
	117: 'f6',
	118: 'f7',
	119: 'f8',
	120: 'f9',
	121: 'f10',
	122: 'f11',
	123: 'f12'

/*
	160: 'lshift', //doesn't work
	161: 'rshift',
	162: 'lctrl',
	163: 'rctrl'
*/
	
};




Input._onKeyDown = function(event) {
    if (this._shouldPreventDefault(event.keyCode)) {
        event.preventDefault();
    }
    if (event.keyCode === 144) {    // Numlock
        this.clear();
    }
    var buttonName = this.keyMapper[event.keyCode];

	buttonName = inputfilter(buttonName) //translate btn to intended function

    if (ResourceHandler.exists() && buttonName === 'ok') {
        ResourceHandler.retry();
    } else if (buttonName) {
        this._currentState[buttonName] = true;
    }
};

Input._onKeyUp = function(event) {
    var buttonName = this.keyMapper[event.keyCode];

	buttonName = inputfilter(buttonName) //translate btn to intended function

    if (buttonName) {
        this._currentState[buttonName] = false;
    }
    if (event.keyCode === 0) {  // For QtWebEngine on OS X
        this.clear();
    }
};


inputfilter = function(btn) {
	if ($gameVariables) {
		vset(398, btn)

		if (btn == "esc") {	vset(397, btn)} //set for gamepad
	}
//	p(btn)
	
	var left = []
	var up = []
	var right = []
	var down = []
	var pageup = []
	var pagedown = []
	var ok = []
	var cancel = []
	var shift = []
	var seek = []

	if (ConfigManager.keysleft) {		left = ConfigManager.keysleft	}
	if (ConfigManager.keysup) {			up = ConfigManager.keysup	}
	if (ConfigManager.keysright) {		right = ConfigManager.keysright	}
	if (ConfigManager.keysdown) {		down = ConfigManager.keysdown	}
	if (ConfigManager.keyspageup) {		pageup = ConfigManager.keyspageup	}
	if (ConfigManager.keyspagedown) {	pagedown = ConfigManager.keyspagedown	}
	if (ConfigManager.keysok) {			ok = ConfigManager.keysok	}
	if (ConfigManager.keyscancel) {		cancel = ConfigManager.keyscancel	}
	if (ConfigManager.keysshift) {		shift = ConfigManager.keysshift	}
	if (ConfigManager.keysseek) {		seek = ConfigManager.keysseek	}

	var debug = ['f9']

	if (left.includes(btn)) {return 'left'}
	if (up.includes(btn)) {return 'up'}
	if (right.includes(btn)) {return 'right'}
	if (down.includes(btn)) {return 'down'}
	if (pageup.includes(btn)) {return 'pageup'}
	if (pagedown.includes(btn)) {return 'pagedown'}
	if (ok.includes(btn)) {return 'ok'}
	if (cancel.includes(btn)) {return 'escape'}
	if (shift.includes(btn)) {return 'shift'}
	if (seek.includes(btn)) {return 'seek'}
	if (debug.includes(btn)) {return 'debug'}

	return btn

//    18: 'control',  // alt
//	var tab = []
//	if (tab.includes(btn)) {return 'tab'}
}




Input.gamepadMapper = {
    0: 'pada',      // A, confirm
    1: 'padb',    	// B, menu/cancel
    2: 'padx',     	// X, log
    3: 'pady',    	// Y, chg shown stats
	6: 'padlt',   	// LT
    4: 'padlb', 	// LB
	7: 'padrt',    	// RT
    5: 'padrb',  	// RB
	8: 'padsel',    // Select, log
	9: 'padstart',  // Start, menu/cancel
	10: 'padl3',    // L3
	11: 'padr3',    // R3
    12: 'padup',    // D-pad up
    13: 'paddown',  // D-pad down
    14: 'padleft',  // D-pad left
    15: 'padright', // D-pad right
};


inputpadfilter = function(btn) {
	if ($gameVariables) {
		vset(397, btn)
	}
//	p(btn)
	
	var left = []
	var up = []
	var right = []
	var down = []
	var pageup = []
	var pagedown = []
	var ok = []
	var cancel = []
	var shift = []
	var seek = []

	if (ConfigManager.padsleft) {		left = ConfigManager.padsleft	}
	if (ConfigManager.padsup) {			up = ConfigManager.padsup	}
	if (ConfigManager.padsright) {		right = ConfigManager.padsright	}
	if (ConfigManager.padsdown) {		down = ConfigManager.padsdown	}
	if (ConfigManager.padspageup) {		pageup = ConfigManager.padspageup	}
	if (ConfigManager.padspagedown) {	pagedown = ConfigManager.padspagedown	}
	if (ConfigManager.padsok) {			ok = ConfigManager.padsok	}
	if (ConfigManager.padscancel) {		cancel = ConfigManager.padscancel	}
	if (ConfigManager.padsshift) {		shift = ConfigManager.padsshift	}
	if (ConfigManager.padsseek) {		seek = ConfigManager.padsseek	}


	if (left.includes(btn)) {return 'left'}
	if (up.includes(btn)) {return 'up'}
	if (right.includes(btn)) {return 'right'}
	if (down.includes(btn)) {return 'down'}
	if (pageup.includes(btn)) {return 'pageup'}
	if (pagedown.includes(btn)) {return 'pagedown'}
	if (ok.includes(btn)) {return 'ok'}
	if (cancel.includes(btn)) {return 'escape'}
	if (shift.includes(btn)) {return 'shift'}
	if (seek.includes(btn)) {return 'seek'}

	return btn
}

Input._pollGamepads = function() {
    if (navigator.getGamepads) {
        var gamepads = navigator.getGamepads();
        if (gamepads) {
            for (var i = 0; i < gamepads.length; i++) {
                var gamepad = gamepads[i];
                if (gamepad && gamepad.connected) {
					if (ConfigManager.gamepad) {
						this._updateGamepadState(gamepad);
					}
                }
            }
        }
    }
};


Input._updateGamepadState = function(gamepad) {
    var lastState = this._gamepadStates[gamepad.index] || [];
    var newState = [];
    var buttons = gamepad.buttons;
    var axes = gamepad.axes;
    var threshold = 0.5;
    newState[12] = false;
    newState[13] = false;
    newState[14] = false;
    newState[15] = false;
    for (var i = 0; i < buttons.length; i++) {
        newState[i] = buttons[i].pressed;
    }
    if (axes[1] < -threshold) {
        newState[12] = true;    // up
    } else if (axes[1] > threshold) {
        newState[13] = true;    // down
    }
    if (axes[0] < -threshold) {
        newState[14] = true;    // left
    } else if (axes[0] > threshold) {
        newState[15] = true;    // right
    }
    for (var j = 0; j < newState.length; j++) {
        if (newState[j] !== lastState[j]) {
            var buttonName = this.gamepadMapper[j];
            if (buttonName) {
				
				buttonName = inputpadfilter(buttonName) //translate btn to bind
				
                this._currentState[buttonName] = newState[j];
            }
        }
    }
    this._gamepadStates[gamepad.index] = newState;
};




Game_Player.prototype.isDebugThrough = function() {
    return Input.isPressed('c') && $gameTemp.isPlaytest();
};

